#pragma once

#include <library/cpp/timezone_conversion/convert.h>

#include <util/draft/datetime.h>
#include <util/generic/maybe.h>

#include <utility>

class TScheduleRangeProvider {
public:
    TScheduleRangeProvider() = default;
    std::pair<NDatetime::TSimpleTM, NDatetime::TSimpleTM> GetRange(const NDatetime::TTimeZone& localTimezone,
                                                                   const TMaybe<NDatetime::TSimpleTM>& searchDate,
                                                                   const int delta = 30);

protected:
    virtual NDatetime::TSimpleTM GetNow();
};

TMaybe<NDatetime::TSimpleTM> ParseCivilTime(const NDatetime::TTimeZone& timezone, const TString& rawSearchDate);

NDatetime::TSimpleTM AddMinutes(NDatetime::TSimpleTM naiveDateTime, i32 minutes);
NDatetime::TSimpleTM ChangeTimeZone(const NDatetime::TSimpleTM& dateTime, const NDatetime::TTimeZone& originalTimeZone, const NDatetime::TTimeZone& otherTimeZone);
