#include "helpers.h"

#include <travel/hotels/lib/cpp/ordinal_date/ordinal_date.h>

i32 NRasp::ToPythonOrdinal(const NDatetime::TSimpleTM& datetime) {
    // date.fromordinal(719163) == datetime.date(1970, 1, 1)
    const i32 COUNT_DAY_BEFORE_1970_01_01 = 719163;

    return NTravel::NOrdinalDate::FromParts(
               1900 + datetime.Year,
               datetime.Mon + 1, // 1 .. 12
               datetime.MDay) +
           COUNT_DAY_BEFORE_1970_01_01;
}
