#pragma once

#include <travel/rasp/route-search-api/proto/rthread.pb.h>

#include <util/draft/datetime.h>
#include <util/generic/ptr.h>
#include <util/generic/ymath.h>
#include <util/datetime/parser.h>

namespace NRasp {
    using object_id_t = ui32;

    constexpr int dayMinutes = 24 * 60;
    static constexpr ui32 bit = 1;

    using TTransportSet = THashSet<TRThread::ETransportType>;

    template <typename T>
    class TQueryType {
    };

    namespace NGetters {
        template <class T>
        class TSimpleIdGetter {
        public:
            object_id_t operator()(const T& object) {
                return object.id();
            }
        };

        template <class T>
        class TObjectGetter {
        public:
            const T& operator()(const T& object) {
                return object;
            }
        };
    }

    inline bool GetBit(ui32 mask, ui32 id) {
        return bool(mask & (bit << id));
    }

    inline TDateTimeFields NextDate(TDateTimeFields date) {
        date.Day += 1;
        if (date.IsOk())
            return date;
        date.Month += 1;
        date.Day = 1;
        if (date.IsOk())
            return date;
        date.Month = 1;
        date.Year += 1;
        return date;
    };

    i32 ToPythonOrdinal(const NDatetime::TSimpleTM& datetime);
}
