#pragma once

#include "travel/rasp/route-search-api/helpers.h"

#include <util/generic/vector.h>
#include <util/generic/hash.h>
#include <util/generic/yexception.h>
#include <util/generic/algorithm.h>

namespace NRasp {
    class TIdNormlizerAlreadyInitialized: public yexception {
    };

    template <class T, typename TKey = object_id_t>
    class TIdNormalizer {
        /*
         * Сущность для сжатия координат. Принимает объекты и хранит упорядоченные ключи от них.
         */
    public:
        TIdNormalizer() {
        }

        template <typename Container>
        TIdNormalizer(const Container& container,
                      std::function<TKey(const T&)> idGetter = NGetters::TSimpleIdGetter<T>())
            : IdGetter(idGetter)
        {
            InitializeBy(container.begin(), container.end());
        }

        template <typename TIter>
        TIdNormalizer(TIter b, TIter e, std::function<TKey(const T&)> idGetter = NGetters::TSimpleIdGetter<T>())
            : IdGetter(idGetter)
        {
            InitializeBy(b, e);
        }

        // Возвращает 0, если ключ не встречался изначально, иначе порядковый номер среди ключей в 1-индексации.
        inline object_id_t GetId(const TKey& x) const noexcept;

        // Аналогично, только прдварительно вычисляет ключ
        inline object_id_t GetIdByObject(const T& obj) const noexcept;

    private:
        template <typename TIter>
        inline void InitializeBy(TIter b, TIter e);

        std::function<TKey(const T&)> IdGetter;
        THashMap<TKey, object_id_t> IdToInnerId;
    };

    template <class T, class TKey>
    inline object_id_t TIdNormalizer<T, TKey>::GetId(const TKey& x) const noexcept {
        auto it = IdToInnerId.find(x);
        return it == IdToInnerId.end() ? 0 : it->second + 1;
    }

    template <class T, typename TKey>
    template <typename TIter>
    void TIdNormalizer<T, TKey>::InitializeBy(TIter b, TIter e) {
        TVector<TKey> keys;
        Transform(b, e, std::back_inserter(keys), IdGetter);
        Sort(keys);
        for (yssize_t i = 0; i < keys.ysize(); i++) {
            IdToInnerId[keys[i]] = i;
        }
    }

    template <class T, typename TKey>
    object_id_t TIdNormalizer<T, TKey>::GetIdByObject(const T& obj) const noexcept {
        auto key = IdGetter(obj);
        return GetId(key);
    }
}
