#pragma once

#include "point_key.h"
#include "wrappers.h"

#include <travel/rasp/route-search-api/proto/rthread.pb.h>
#include <travel/rasp/route-search-api/proto/station.pb.h>

#include <util/generic/hash_set.h>

namespace NRasp {
    class TLimitConditions {
    public:
        /*
         * Если первая и вторая точка, это станции из одного города, или одна из них город,
         * а другая станция этого города, исключаем поезда и самолеты из выдачи.
         * Иначе ищем по всему.
         * Из поиска исключаем станции с важностью меньше чем NOT_IN_TABLO, если ищем между городами.
         */

        TLimitConditions(const TPointKey& fromPointKey, const TPointKey& toPointKey,
                         const TTransportSet& transportTypes,
                         const TVector<TStationWrapper>& stations,
                         bool extended = false);

        inline bool Allow(TStation::EMajority fromMajorityId,
                          TStation::EMajority toMajorityId,
                          TRThread::ETransportType transportType) const noexcept {
            if (!TransportTypes_.contains(transportType))
                return false;
            if (transportType == TRThread::BUS)
                return true;
            return fromMajorityId <= FromMaxMajorityID_ && toMajorityId <= ToMaxMajorityID_;
        }

        inline const TTransportSet& TransportTypes() const noexcept {
            return TransportTypes_;
        }

        inline const TPointKey& FromPointKey() const noexcept {
            return FromPointKey_;
        }

        inline const TPointKey& ToPointKey() const noexcept {
            return ToPointKey_;
        }

        inline const TStation::EMajority& FromMaxMajorityID() const noexcept {
            return FromMaxMajorityID_;
        }

        inline const TStation::EMajority& ToMaxMajorityID() const noexcept {
            return ToMaxMajorityID_;
        }

    private:
        TPointKey FromPointKey_;
        TPointKey ToPointKey_;
        TTransportSet TransportTypes_;
        TStation::EMajority FromMaxMajorityID_;
        TStation::EMajority ToMaxMajorityID_;
    };
}
