#include "point_key.h"

#include <util/string/cast.h>

using namespace NRasp;

bool TPointKey::TryParseFromString(const TString& stringPointKey) {
    if (stringPointKey.size() < 2)
        return false;
    char typeSymbol = stringPointKey[0];
    if (typeSymbol == settlementPrefix) {
        this->Type_ = EPointKeyType::Settlement;
    } else if (typeSymbol == stationPrefix) {
        this->Type_ = EPointKeyType::Station;
    } else {
        return false;
    }
    if (TryIntFromString<10>(stringPointKey.substr(1), Id_))
        return Id_ != 0;
    return false;
}

TString TPointKey::ToString() const {
    TStringStream ss;

    switch (Type_) {
        case EPointKeyType::Settlement:
            ss << 'c';
            break;
        case EPointKeyType::Station:
            ss << 's';
            break;
        default:
            ythrow yexception() << "Unexpected PointKeyType TPointKey::ToString()";
    }
    ss << Id_;

    return ss.Str();
}
