#pragma once

#include "wrappers.h"

namespace NRasp {
    class TRawSegment {
    public:
        TRawSegment(const TThreadStationWrapper& departure,
                    const TThreadStationWrapper& arrival,
                    const TRThreadWrapper& thread) noexcept
            : Departure_(departure)
            , Arrival_(arrival)
            , Thread_(thread)
        {
        }

        TRawSegment(const TRawSegment& other) noexcept
            : Departure_(other.Departure_)
            , Arrival_(other.Arrival_)
            , Thread_(other.Thread_)
        {
        }

        inline const TThreadStationWrapper& Departure() const noexcept {
            return Departure_;
        }

        inline const TThreadStationWrapper& Arrival() const noexcept {
            return Arrival_;
        }

        inline const TRThreadWrapper& Thread() const noexcept {
            return Thread_;
        }

        inline NDatetime::TTimeZone DepartureTimezone() const noexcept {
            return Departure_.Station().Timezone();
        }

        inline NDatetime::TTimeZone ArrivalTimezone() const noexcept {
            return Arrival_.Station().Timezone();
        }

    private:
        const TThreadStationWrapper& Departure_;
        const TThreadStationWrapper& Arrival_;
        const TRThreadWrapper& Thread_;
    };

    class TRawSegmentKeyGetter {
    private:
        yssize_t StationCount;

    public:
        TRawSegmentKeyGetter(yssize_t stationCount) noexcept
            : StationCount(stationCount + 10)
        {
        }

        inline ui64 operator()(const TRawSegment& segment) const {
            const TThreadStationWrapper& departure = segment.Departure();
            const TThreadStationWrapper& arrival = segment.Arrival();
            const TRThreadWrapper& thread = segment.Thread();

            auto startMinute = static_cast<ui64>(thread.StartTimeInMinutes());

            ui64 key = 0;
            ui64 stationCnt = StationCount;
            key = key * stationCnt + departure.StationId();
            key = key * stationCnt + arrival.StationId();
            key = key * dayMinutes + (startMinute + departure.DepartureOffset().GetRef()) % dayMinutes;
            key = key * dayMinutes + (startMinute + arrival.ArrivalOffset().GetRef()) % dayMinutes;

            return key;
        }
    };
}
