#pragma once

#include <util/system/thread.h>

class RunTimeLogger {
public:
    RunTimeLogger(const TString& title) : Title(title), StartTime(TInstant::Now()) {}
    void Emit() {
        if (Emitted) {
            return;
        }
        Emitted = true;
        Clog << TThread::CurrentThreadId() << " " << Title << " done in "
             << (TInstant::Now() - StartTime).SecondsFloat() << " seconds" << Endl;
    }
    ~RunTimeLogger() {
        Emit();
    }
private:
    const TString Title;
    TInstant StartTime;
    bool Emitted = false;
};
