#pragma once

#include "query_reader.h"
#include "rasp_database.h"
#include "rasp_search_index.h"
#include "segment_finders.h"

#include <util/draft/datetime.h>
#include <util/generic/array_ref.h>

#include <algorithm>

namespace NRasp {
    using TSegments = TVector<TSegment>;

    using TArrayRange = std::pair<const size_t, const size_t>;

    using TSegmentsWithRange = std::pair<const TSegments*, const TArrayRange>;

    using TStationSegmentsWithRanges = std::pair<TSegmentsWithRange, TSegmentsWithRange>;

    class TStationSegmentsIndex {
    public:
        explicit TStationSegmentsIndex(
            const TWrappedRaspDatabase& database,
            const TRaspSearchIndex& searchIndex,
            const TTransportSet& transportTypes);

        TStationSegmentsWithRanges GetSegments(
            object_id_t stationId,
            const NDatetime::TSimpleTM& minEventTM,
            const NDatetime::TSimpleTM& maxEventTM) const;

        TStationSegmentsWithRanges GetSegments(const TStationQuery& query) const;

    private:
        TSegments FindSegments(
            const TRaspSearchIndex& searchIndex,
            object_id_t stationId,
            const NDatetime::TSimpleTM& minEventTM,
            const NDatetime::TSimpleTM& maxEventTM,
            TCommonSegmentFinder::EEventType eventType) const;

        TArrayRange GetSegmentsRange(
            const TSegments& segments,
            const NDatetime::TSimpleTM& minEventTM,
            const NDatetime::TSimpleTM& maxEventTM,
            TSegmentEventTMGetter getEventTM) const;

    private:
        THashMap<object_id_t, std::pair<TSegments, TSegments>> Index;
    };
}
