#include "currencies.h"

#include <library/cpp/http/simple/http_client.h>
#include <util/string/builder.h>

using namespace NRasp;

const THashMap<TCurrency, double>& NRasp::GetRates(ELanguage nationalVerison) {
    Y_ENSURE(!Rates.empty());
    return Rates[nationalVerison];
}

THashMap<TCurrency, double> LoadRates(const TSimpleHttpClient& httpClient, TString nationalVersion) {
    TString response;
    TStringOutput output(response);
    TString relativePath = TStringBuilder() << "/ru/currencies/?national_version=" << nationalVersion << "&base=RUB";
    httpClient.DoGet(relativePath, &output);

    return {};
}

THashMap<TCurrencyProto::ECurrency, object_id_t> TCurrency::Currencies;

void NRasp::LoadRates(const TString& source) {
    TSimpleHttpClient httpClient{TSimpleHttpClientOptions{source}};
    Rates.clear();

    Rates[LANG_RUS] = LoadRates(httpClient, "ru");
    Rates[LANG_UKR] = LoadRates(httpClient, "ua");
}

void TCurrency::AddCurrency(TCurrencyProto::ECurrency currency, object_id_t id) {
    Currencies[currency] = id;
}
