#include "static_tariff.h"
#include "static_tariff_search_index.h"

#include <travel/rasp/route-search-api/wrappers.h>
#include <travel/rasp/route-search-api/limit_condition.h>

#include <util/string/builder.h>

using namespace NRasp;
using NDatetime::TSimpleTM;

TMaybe<TPrice> TStaticTariffService::GetStaticTariff(const TStaticTariffSearchIndex& tariffSearchIndex,
                                                     TStaticTariffQuery query) const {
    TStaticTariffKey key{
        query.StationFrom,
        query.StationTo,
        query.ThreadId,
        query.Departure};

    auto tariffs = tariffSearchIndex.GetTariffs(key);

    auto needToRemove = [&](const TThreadTariffWrapper* tariff) {
        return !tariff->RunsAt(query.Month, query.Day);
    };
    EraseIf(tariffs, needToRemove);

    if (tariffs.empty())
        return {};
    
    auto tariff = tariffs[0];
    if (tariffs.ysize() > 1) {
	auto value = TPrice(tariff->Tariff(), tariff->Currency()).BaseValue();
	for (int i = 1; i < tariffs.ysize(); i++) {
	    auto currentTariff = tariffs[i];
	    auto currentValue = TPrice(currentTariff->Tariff(), currentTariff->Currency()).BaseValue();
  	    if (currentValue < value) {
	        value = currentValue;
		tariff = currentTariff;
	    }
        }
    }
    auto price = TPrice(tariff->Tariff(), tariff->Currency());

    const auto& rates = GetRates(query.NationalVersion);

    price.Rebase(rates, TCurrency(query.NationalVersion));

    return price;
}
