#pragma once

#include "currencies.h"
#include "static_tariff_search_index.h"

#include <travel/rasp/route-search-api/wrappers.h>
#include <travel/rasp/route-search-api/rasp_database.h>
#include <travel/rasp/route-search-api/point_key.h>
#include <travel/rasp/route-search-api/proto/rthread.pb.h>
#include <travel/rasp/route-search-api/segment.h>

#include <library/cpp/langs/langs.h>
#include <library/cpp/json/json_value.h>

#include <util/draft/datetime.h>
#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NRasp {
    struct TStaticTariffQuery {
        object_id_t StationFrom; // Внутренний id
        object_id_t StationTo;   // Внутренний id
        object_id_t ThreadId;    // Внутренний id
        ui32 Departure;          // Минуты с начала дня

        ELanguage NationalVersion = LANG_RUS;
        ui32 Month;
        ui32 Day;
    };

    class TStaticTariffService {
    public:
        TMaybe<TPrice> GetStaticTariff(
            const TStaticTariffSearchIndex& tariffSearchIndex,
            TStaticTariffQuery query) const;
    };

    class TStaticTariffServiceWithContext {
    private:
        const TStaticTariffSearchIndex& TariffSearchIndex;
        TStaticTariffService Service;

    public:
        TStaticTariffServiceWithContext(const TStaticTariffSearchIndex& tariffSearchIndex)
            : TariffSearchIndex(tariffSearchIndex)
        {
        }

        TMaybe<TPrice> GetStaticTariff(TStaticTariffQuery query) const {
            return Service.GetStaticTariff(TariffSearchIndex, query);
        }
    };
}
