#include "static_tariff_search_index.h"

using namespace NRasp;

bool TStaticTariffKey::operator==(const TStaticTariffKey& rhs) const {
    return std::tie(PointFrom, PointTo, Departure) == std::tie(rhs.PointFrom, rhs.PointTo, rhs.Departure);
}

bool TStaticTariffKey::operator!=(const TStaticTariffKey& rhs) const {
    return !(rhs == *this);
}

TStaticTariffSearchIndex::TStaticTariffSearchIndex(
    const TWrappedRaspDatabase& database,
    const TTransportSet& transportTypes)
    : Database(database)
{
    for (const auto& tariff : database.GetItems<TThreadTariffWrapper>()) {
        if (!(tariff.HasStationFrom() && tariff.HasStationTo() && tariff.HasThread() && transportTypes.contains(tariff.Thread().TransportType()))) {
            continue;
        }

        TStaticTariffKey key{
            tariff.StationFrom().Id(),
            tariff.StationTo().Id(),
            tariff.Thread().Id(),
            static_cast<object_id_t>(tariff.DepartureInMinutes())};

        TariffsInfo[key].push_back(&tariff);
    }
}
