#pragma once

#include <travel/rasp/route-search-api/rasp_database.h>
#include <travel/rasp/route-search-api/rasp_search_index.h>

namespace NRasp {
    struct TStaticTariffKey {
        object_id_t PointFrom;
        object_id_t PointTo;
        object_id_t ThreadId;
        object_id_t Departure;

        bool operator==(const TStaticTariffKey& rhs) const;

        bool operator!=(const TStaticTariffKey& rhs) const;

        operator size_t() const {
            return 3 * PointFrom + 11 * PointTo + 193 * ThreadId + 223 * Departure;
        }
    };

    class TStaticTariffSearchIndex {
    public:
        using TTariffsList = TVector<const TThreadTariffWrapper*>;

    public:
        explicit TStaticTariffSearchIndex(const TWrappedRaspDatabase& database, const TTransportSet& transportTypes);

        TTariffsList GetTariffs(const TStaticTariffKey& key) const {
            return TariffsInfo.contains(key) ? TariffsInfo.at(key) : TTariffsList{};
        }

        template <typename T>
        inline const TVector<T>& GetItems() const {
            return Database.GetItems<T>();
        }

        template <typename T>
        inline bool Exists(object_id_t id) const {
            return Database.Exists<T>(id);
        }

        inline const NDatetime::TTimeZone& GetTimezoneById(int id) const {
            return Database.GetTimezoneById(id);
        }

        template <typename T>
        inline object_id_t GetInnerId(object_id_t id) const {
            return Database.GetInnerId<T>(id);
        }

        template <typename T>
        inline const T& GetItemWithId(int id) const {
            return Database.GetItemWithId<T>(id);
        }

        template <typename T>
        inline yssize_t GetMaxId() const {
            return Database.GetMaxId<T>();
        }

    private:
        const TWrappedRaspDatabase& Database;
        THashMap<TStaticTariffKey, TTariffsList> TariffsInfo;
    };
}
