#pragma once

#include <library/cpp/langs/langs.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NRasp {
    class TSettlementWrapper;
    class TStationWrapper;
    class TRThreadWrapper;
    class TWrappedRaspDatabase;

    class TDefaultTitleGenerator {
    public:
        TString GenerateTitle(const TRThreadWrapper& threadWrapper,
                              ELanguage lang,
                              const TWrappedRaspDatabase& raspDatabase) const;

    protected:
        virtual TString PartToText(const TSettlementWrapper& pointWrapper, ELanguage lang) const;
        virtual TString PartToText(const TStationWrapper& pointWrapper, ELanguage lang) const;
    };

    class TSuburbanTitleGenerator : TDefaultTitleGenerator {
    protected:
        TString PartToText(const TStationWrapper& poingWrapper, ELanguage lang) const override;
    };
}
