#include "url_builders.h"

#include "travel/rasp/route-search-api/config.h"

#include <library/cpp/uri/uri.h>

#include <library/cpp/cgiparam/cgiparam.h>

namespace NRasp {
    namespace NUrlBuilders {
        TString BuildThreadUrl(bool is_mobile, const NRasp::TSegment& segment, const NRasp::TDirectionQuery& query,
                               const NRasp::THostConfig& config) {
            TCgiParameters params;

            params.InsertEscaped("wizardReqId", query.MainReqid);
            params.InsertEscaped("point_to", query.ToPointKey.ToString());
            params.InsertEscaped("point_from", query.FromPointKey.ToString());
            params.InsertEscaped("station_from", std::to_string(segment.DepartureWrapper().Station().OuterId()));
            params.InsertEscaped("station_to", std::to_string(segment.ArrivalWrapper().Station().OuterId()));
            params.InsertEscaped("departure_from", segment.LocalDepartureTime().ToString("%Y-%m-%d %H:%M:%S"));

            NUri::TUri uri(
                config.GetHostByTld(is_mobile, query.Tld),
                0,
                "/thread/" + segment.ThreadUid(),
                params.Print(),
                "https");
            return uri.PrintS();
        }

        TString BuildThreadUrl(bool is_mobile, const NRasp::TSegment& segment, const NRasp::TStationQuery& query,
                               const NRasp::THostConfig& config) {
            TCgiParameters params;

            params.InsertEscaped("station_from", std::to_string(segment.DepartureWrapper().Station().OuterId()));
            params.InsertEscaped("station_to", std::to_string(segment.ArrivalWrapper().Station().OuterId()));
            params.InsertEscaped("departure_from", segment.LocalDepartureTime().ToString("%Y-%m-%d %H:%M:%S"));

            NUri::TUri uri(
                config.GetHostByTld(is_mobile, query.Tld),
                0,
                "/thread/" + segment.ThreadUid(),
                params.Print(),
                "https");
            return uri.PrintS();
        }
    }

}
