#include "travel/rasp/route-search-api/helpers.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/random/random.h>

Y_UNIT_TEST_SUITE(TestGetBit) {
    void Test(ui32 mask, TVector<bool> expected) {
        for (size_t i = 0; i < 32; i++) {
            UNIT_ASSERT_EQUAL(expected[i], NRasp::GetBit(mask, i));
        }
    }

    TVector<bool> GetBitsOfMask(ui32 mask) {
        TVector<bool> result;
        for (size_t i = 0; i < 32; i++, mask /= 2) {
            result.push_back(mask % 2);
        }
        return result;
    }

    Y_UNIT_TEST(SimpleTest) {
        ui32 mask = 40;
        TVector<bool> bits(32, 0);
        bits[3] = bits[5] = 1;
        Test(mask, bits);
    }

    Y_UNIT_TEST(StressTest) {
        size_t countTest = 10000;
        for (size_t i = 0; i < countTest; i++) {
            ui32 mask = RandomNumber<ui32>();
            auto bits = GetBitsOfMask(mask);
            Test(mask, bits);
        }
    }

    Y_UNIT_TEST(ToPythonOrdinal) {
        NDatetime::TSimpleTM datetime(2018, 1, 1);
        UNIT_ASSERT_EQUAL(NRasp::ToPythonOrdinal(datetime), 736695);
    }
}
