#include "travel/rasp/route-search-api/id_normalizer.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/string.h>
#include <util/random/random.h>
#include <util/generic/algorithm.h>
#include <util/random/shuffle.h>

using object_id_t = NRasp::object_id_t;

TVector<object_id_t> GenerateIds(size_t count) {
    TSet<object_id_t> used;

    for (size_t i = 0; i < count; i++) {
        do {
            object_id_t id = RandomNumber<object_id_t>() + 1;
            if (!used.contains(id) && id != 0) {
                used.insert(id);
                break;
            }
        } while (true);
    }

    TVector<object_id_t> ids(used.begin(), used.end());

    ShuffleRange(ids);
    return ids;
}

Y_UNIT_TEST_SUITE(ObjectInfoTest) {
    using namespace NRasp;

    Y_UNIT_TEST(SimpleTest) {
        TVector<object_id_t> ids = {12, 7, 10, 5};
        TIdNormalizer<object_id_t> objectsInfo(ids, NGetters::TObjectGetter<object_id_t>());

        UNIT_ASSERT_EQUAL(objectsInfo.GetId(5), 1);
        UNIT_ASSERT_EQUAL(objectsInfo.GetId(7), 2);
        UNIT_ASSERT_EQUAL(objectsInfo.GetId(10), 3);
        UNIT_ASSERT_EQUAL(objectsInfo.GetId(12), 4);
    }

    Y_UNIT_TEST(TestCompare) {
        TIdNormalizer<int, int> objectsInfo(TVector<int>{1, 2, 3}, [](auto& x) { return -x; });

        UNIT_ASSERT_EQUAL(objectsInfo.GetId(0), 0);
        UNIT_ASSERT_EQUAL(objectsInfo.GetId(-1), 3);
        UNIT_ASSERT_EQUAL(objectsInfo.GetId(-2), 2);
        UNIT_ASSERT_EQUAL(objectsInfo.GetId(-3), 1);
    }

    Y_UNIT_TEST(StressTest) {
        size_t testCount = 1000;
        size_t objectCount = 1000;
        for (size_t i = 0; i < testCount; i++) {
            auto ids = GenerateIds(objectCount);
            TIdNormalizer<object_id_t> objectsInfo(ids, NGetters::TObjectGetter<object_id_t>());
            Sort(ids);

            for (size_t j = 0; j < objectCount; j++) {
                UNIT_ASSERT_EQUAL(objectsInfo.GetId(ids[j]), j + 1);
            }
        }
    }
}
