#include "travel/rasp/route-search-api/map_keys_wrapper.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/random/random.h>
#include <util/generic/vector.h>

std::pair<size_t, size_t> GeneratePair() {
    return {RandomNumber<size_t>(), RandomNumber<size_t>()};
};

TVector<std::pair<size_t, size_t>> GenerateRandomPairs(size_t cnt) {
    TVector<std::pair<size_t, size_t>> pairs(cnt);
    for (auto& p : pairs)
        p = GeneratePair();
    return pairs;
};

Y_UNIT_TEST_SUITE(TestMapWrapper) {
    using namespace NRasp;

    Y_UNIT_TEST(TestAdd) {
        THashMapKeysWrapper<int, int> wrapper;
        wrapper[1] = 2;
        wrapper[2] = 3;
        wrapper[0] = 2;
        wrapper.Normalize();
        UNIT_ASSERT_EQUAL(wrapper.GetKeys().size(), 3);
        UNIT_ASSERT_EQUAL(wrapper.GetKeys(), TVector<int>({0, 1, 2}));
    }

    Y_UNIT_TEST(StressTestAdd) {
        auto pairs = GenerateRandomPairs(1000);

        THashMapKeysWrapper<size_t, size_t> wrapper;
        TSet<size_t> keys;

        for (auto& [key, value] : pairs) {
            keys.insert(key);
            wrapper[key] = value;
        }

        wrapper.Normalize();
        UNIT_ASSERT_EQUAL(wrapper.GetKeys(), TVector<size_t>(keys.begin(), keys.end()));
    }

    Y_UNIT_TEST(TestCommonKeys) {
        THashMapKeysWrapper<int, int> first = {
            {0, 1},
            {1, 2},
            {3, 4}};
        THashMapKeysWrapper<int, int> second = {
            {1, 1},
            {4, 5},
            {3, 4}};

        first.Normalize();
        second.Normalize();

        UNIT_ASSERT_EQUAL(first.GetCommonKeysWith(second), TVector<int>({1, 3}));
    }
}
