#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/timezone_conversion/convert.h>
#include <travel/rasp/route-search-api/url_builders.h>

Y_UNIT_TEST_SUITE(UrlBuilders) {
    Y_UNIT_TEST(BuildMobileUrl) {
        using namespace NRasp;
        TSettlement msk;
        TStation mskStation;
        mskStation.set_id(1);
        TStationWrapper mskStationWrapper{mskStation, 666, msk, 666};

        TSettlement ekb;
        TStation ekb_station;
        ekb_station.set_id(2);
        TStationWrapper ekbStationWrapper{ekb_station, 666, ekb, 666};

        TRThread thread;
        TRThreadWrapper threadWrapper{thread, 100, "0"};

        NDatetime::TTimeZone utcTz;

        TThreadStation mskRtStation;
        mskRtStation.set_has_departure(true);
        TThreadStationWrapper mskRtStationWrapper{mskRtStation, 1000, utcTz, {mskStationWrapper}, {threadWrapper}};
        TThreadStation ekbRtStation;
        ekbRtStation.set_has_arrival(true);
        TThreadStationWrapper ekbRtStationWrapper{ekbRtStation, 2000, utcTz, {ekbStationWrapper}, {threadWrapper}};

        NDatetime::TSimpleTM naiveThreadStartDateTime = NDatetime::TSimpleTM(2012, 9, 27);
        TRawSegment rawSegment{mskRtStationWrapper, ekbRtStationWrapper, threadWrapper};
        TSegment segment{rawSegment, naiveThreadStartDateTime};

        NDatetime::TSimpleTM today;

        THostConfig config;
        config.AddHost(false, "desktop-some-host.ru", "ru");
        config.AddHost(false, "desktop-some-host.ua", "ua");
        config.AddHost(true, "mobile-some-host.ru", "ru");

        {
            TDirectionQuery query(
                TPointKey{10'000, TPointKey::EPointKeyType::Settlement},
                TPointKey{20'000, TPointKey::EPointKeyType::Settlement},
                today, today, today, "ru", "test_reqid");

            {
                auto res = NUrlBuilders::BuildThreadUrl(false, segment, query, config);

                UNIT_ASSERT_STRINGS_EQUAL(res, "https://desktop-some-host.ru/thread/0?"
                                               "departure_from=2012-09-27+00%3A00%3A00&point_from=c10000&"
                                               "point_to=c20000&station_from=1&station_to=2&wizardReqId=test_reqid");
            }
            {
                auto res = NUrlBuilders::BuildThreadUrl(true, segment, query, config);
                UNIT_ASSERT_STRINGS_EQUAL(res, "https://mobile-some-host.ru/thread/0?"
                                               "departure_from=2012-09-27+00%3A00%3A00&point_from=c10000&"
                                               "point_to=c20000&station_from=1&station_to=2&wizardReqId=test_reqid");
            }
        }
        {
            TDirectionQuery query(
                TPointKey{10'000, TPointKey::EPointKeyType::Settlement},
                TPointKey{20'000, TPointKey::EPointKeyType::Settlement},
                today, today, today, "ua", "test_reqid");

            {
                auto res = NUrlBuilders::BuildThreadUrl(false, segment, query, config);

                UNIT_ASSERT_STRINGS_EQUAL(res, "https://desktop-some-host.ua/thread/0?"
                                               "departure_from=2012-09-27+00%3A00%3A00&point_from=c10000&"
                                               "point_to=c20000&station_from=1&station_to=2&wizardReqId=test_reqid");
            }
            {
                auto res = NUrlBuilders::BuildThreadUrl(true, segment, query, config);
                UNIT_ASSERT_STRINGS_EQUAL(res, "https://mobile-some-host.ru/thread/0?"
                                               "departure_from=2012-09-27+00%3A00%3A00&point_from=c10000&"
                                               "point_to=c20000&station_from=1&station_to=2&wizardReqId=test_reqid");
            }
        }
    }
}
