# Деплой в Deploy
Проект в Deploy: [rzd_proxy](https://deploy.yandex-team.ru/project/rzd_proxy)

Ни в коем случае не делать изменений конфига через интерфейс Deploy!
В интерфейсе поддержаны не все параметры конфига, и часть настроек исчезнет, если выкатить через интерфейс.
(2020.09.11: через новый интерфейс New Config, который сейчас beta - можно катить, он не перетирает настройки)

Порядок выкатки:

1) В IDM должна быть заказана роль Репозитории / rasp/rzd_proxy / owner

2) Собрать образ (получив OAuth-токен [здесь](https://sandbox.yandex-team.ru/oauth))
    ```
    docker build -t=rzd_proxy --build-arg sandbox_oauth_token=$SANDBOX_OAUTH_TOKEN $ARC/travel/rasp/rzd_proxy
    ```
3) Залить образ в registry
    ```
    RZD_PROXY_VERSION=0.1  # поднять версию
    docker tag rzd_proxy registry.yandex.net/rasp/rzd_proxy:$RZD_PROXY_VERSION
    docker push registry.yandex.net/rasp/rzd_proxy:$RZD_PROXY_VERSION
    ```

4) В файле deploy_stage_rzd.yml:
- в images_for_boxes изменить версию образа на новую
- в revision_info.description изменить описание версии
- Если имеющийся файл не актуален (меняли настройки через интерфейс), то нужно сначала скачать последнюю версию:
    ```
    ya tool dctl get stage rzd_proxy > $ARC/travel/rasp/rzd_proxy/deploy_stage_rzd.yml
    ```

5) Отправить новый конфиг в Deploy
    ```
    ya tool dctl put stage $ARC/travel/rasp/rzd_proxy/deploy_stage_rzd.yml
    ```
6) Сохранить изменения в Аркадию


# Хосты
Клиент [suburban_tasks](https://a.yandex-team.ru/arc/trunk/arcadia/travel/rasp/suburban_tasks/) получает список хостов rzd_proxy с использованием yp endpoints. Текущий список можно посмотреть так:
```
ya tool dctl list endpoint rzd_proxy.DeployUnit1
```

# Ключи и дистрибутив VipNet
Дистрибутив и ключи лежат в sandbox-ресурсе (см. Dockerfile), откуда и достаются при сборке.
Ключи устанавливаются не при сборке, а при запуске контейнера, так как:
- при установке ключей инсталлятор пытается запустить vipnet-client. Это невозможно при сборке, поэтому инсталлятор падает
- у нас есть 3 ключа, для использования по одному в кажом дц. Поэтому выбрать и поставить нужный ключ можно только при деплое

В sandbox-ресурсе лежит папка vipnet с дистрибутивом и ключами для каждого дц:
```
104K Jun 22 18:59 key_man.dst
104K Jun 22 18:59 key_sas.dst
104K Jun 22 18:59 key_vla.dst
 11M Jun  8 11:39 vipnetclient_4.6.0-2691_amd64.deb
```
Пароли от ключей [лежат в yav](https://yav.yandex-team.ru/secret/sec-01cmse0v1wbnmxh3td1tkpwhry)

Для обновления ключей/дистра нужно:
- скачать sandbox-ресурс
- в полученной папке vipnet обновить файлы.
- залить папку в новый ресурс:
ya upload --ttl=inf --backup -d="RASPFRONT-7471 VipNet deb package & keys" vipnet
- обновить ссылку на ресурс в Dockerfile
- обновить пароли для ключей в yav
- обновить версию yav-секрета в Dockerfile
- убрать или изменить энв `VIPNETCLIENT_FROM_DUMP` из `deploy_stage_rzd.yml` (после того, как новая конфиурация сдампится в MDS - вернуть)
- собрать и задеплоить новый образ
- желательно удалить старый ресурс, иначе он вечно будет лежать в sandbox

# Деплой из дампа конфигурации
https://st.yandex-team.ru/RASPFRONT-8831

Раз в час конфигурация vipnetclinet дампится в MDS по пути `rzd-proxy-dump/<dc>_dump.zip`. При выставленном энве `VIPNETCLIENT_FROM_DUMP='yes'` деплой будет производиться не из ключей, а из последней версии дампа.


# Запуск локально
Для работы прокси требуется внешний ipv4 с доступом из интернета. А также ключ.
Если для разработки использовать имеющийся в сборке ключ, то один из продовых инстансов отвалится.
Так что вы должны точно понимать, что делаете, прежде чем запускать руками.

Нужно понимать, что запуская с бакетом `rasp-bucket`, может быть перетёрт дамп продовой конфигурации. Поэтому лучше использовать тестовый MDS:
- Залить в MDS на тестовый бакет `rasp-test-bucket` нужный дамп (по dc) из `rasp-bucket`
- При запуске указвать `-e MDS_BUCKET=rasp-test-bucket`

Для установки конфигурации:
- из ключа: `-e VIPNETCLIENT_FROM_DUMP=no`
- из дампа: `-e VIPNETCLIENT_FROM_DUMP=yes`

Данные для MDS можно взять из [yav](https://yav.yandex-team.ru/secret/sec-01cma58wwavd78bm1phjtpwzp6)

```
docker run --rm -it --network=host -e DEPLOY_NODE_DC=sas -e VIPNET_KEY_PASSWORD_sas=<mypasword> -e MDS_ACCESS_KEY_ID=<access_key_id> -e MDS_ACCESS_SECRET_KEY=<access_secret_key> -e VIPNETCLIENT_FROM_DUMP=<yes/no> -e MDS_BUCKET=<bucket> --device /dev/net/tun --cap-add=NET_ADMIN rzd_proxy /bin/bash -c "/bin/vipnetclient_init.sh && vipnetclient start && exec supervisord -c /etc/supervisor/supervisord.conf"
```
