#!/usr/bin/env bash

vipnetclient stop

{
    echo "DEPLOY_NODE_DC=\"${DEPLOY_NODE_DC}\""
    echo "MDS_ACCESS_KEY_ID=\"${MDS_ACCESS_KEY_ID}\""
    echo "MDS_ACCESS_SECRET_KEY=\"${MDS_ACCESS_SECRET_KEY}\""
    echo "MDS_BUCKET=\"${MDS_BUCKET}\""
} > /dumper/.env

if [[ "${VIPNETCLIENT_FROM_DUMP}" == "yes" ]]; then
    echo "Deploy from dump"
    # Запуск vipnetclient из сдампленного в MDS конфига
    python3 /dumper/mds_client.py download
    unzip -q /dumper/${DEPLOY_NODE_DC}_dump.zip.dump -d /
    rm /dumper/${DEPLOY_NODE_DC}_dump.zip.dump
else
    echo "Deploy from keys"
    # В Ya.Deploy на диске могут остаться предыдущие установленные ключи и/или записанное состояние работающего клиента.
    # Поэтому предварительно их сносим, иначе не сможем поставить новые ключи.
    echo y | vipnetclient deletekeys
    # Ставим ключи. У нас имеется 3 лицензии - для деплоя по 1 клиенту в трех ДЦ.
    # Поэтому просто выбираем ключ по переменной DEPLOY_NODE_DC, означающей один из датацентров - man, vla, sas
    # Пароль от ключа берем из переменной вида VIPNET_KEY_PASSWORD_sas
    export VIPNET_KEY_PATH=`/opt/get_env.py vipnet_key_path`
    export VIPNET_KEY_PASSWORD=`/opt/get_env.py vipnet_key_password`
    echo $VIPNET_KEY_PASSWORD | vipnetclient installkeys $VIPNET_KEY_PATH
    vipnetclient stop
fi
