#!/usr/bin/python
import os
import sys


def log(msg):
    sys.stderr.write("{}\n".format(msg))


def get_vipnet_key_path():
    dc = os.environ['DEPLOY_NODE_DC']
    return '/tmp/vipnet/key_{}.dst'.format(dc)


def get_vipnet_key_password():
    dc = os.environ['DEPLOY_NODE_DC']
    pwd_var_name = 'VIPNET_KEY_PASSWORD_' + dc
    log("get password from: {}".format(pwd_var_name))
    return os.environ[pwd_var_name]


if __name__ == '__main__':
    # log("get_env: {}".format(sys.argv[1]))
    if sys.argv[1] == 'vipnet_key_password':
        result = get_vipnet_key_password()
    elif sys.argv[1] == 'vipnet_key_path':
        result = get_vipnet_key_path()
    else:
        raise Exception('Unknown command', sys.argv[1])

    print(result)
