# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
import logging
import time

import settings

import ibm_db

from rzd_utils import rzd_db_manager, get_connect, rzd_sql_callproc, get_rowdicts_from_resource, get_raw_connection


log = logging.getLogger(__name__)


FETCH_TRTYPE = 2  # suburban
FETCH_DATE_FORMAT = '%Y-%m-%d-%H.%M'


def rzd_check_data(verbose=True, rzd_hostname=None, rzd_port=None):
    from datetime import datetime, timedelta
    dt_to = datetime.utcnow() - timedelta(hours=1)
    dt_from = dt_to - timedelta(minutes=5)

    if rzd_hostname:
        settings.RZD_HOSTNAME = rzd_hostname

    if rzd_port:
        settings.RZD_PORT = rzd_port

    if verbose:
        print('==' * 20, 'rzd_check_data: rzd conn: {}:{}'.format(settings.RZD_HOSTNAME, settings.RZD_PORT))
    res, tries = fetch_data(dt_from, dt_to)

    if verbose:
        print('==' * 20, 'rzd_check_data: rzd conn: {}:{}'.format(settings.RZD_HOSTNAME, settings.RZD_PORT))
        print('example row\n', res[0])
        print("rows", len(res))

    return res


def fetch_data(dt_from, dt_to, retries=1):
    dt_from_str = dt_from.strftime(FETCH_DATE_FORMAT)
    dt_to_str = dt_to.strftime(FETCH_DATE_FORMAT)

    for tries_count in range(1, retries + 1):
        try:
            res = try_get(dt_from_str, dt_to_str)
            return res, tries_count
        except Exception:
            log.exception(u'Unable to fetch data from rzd')
            if tries_count == retries:
                raise

            SUBURBAN_EVENTS_GET_RZD_DATA_RETRY_DELAY = 2
            time.sleep(SUBURBAN_EVENTS_GET_RZD_DATA_RETRY_DELAY)


def try_get(dt_from_str, dt_to_str):
    with rzd_db_manager():
        connect = get_connect(db_name=settings.RZD_SUBURBAN_EVENTS_DB)
        result = rzd_sql_callproc(connect, '@LVGD01.TR2PROC', (FETCH_TRTYPE, dt_from_str, dt_to_str))
        resource = result[0]
        rowdicts = get_rowdicts_from_resource(resource)
        ibm_db.commit(connect)
        return rowdicts


def try_get_light(dt_from_str, dt_to_str):
    connect = get_raw_connection(db_name=settings.RZD_SUBURBAN_EVENTS_DB)
    result = rzd_sql_callproc(connect, '@LVGD01.TR2PROC', (FETCH_TRTYPE, dt_from_str, dt_to_str))
    resource = result[0]
    rowdicts = get_rowdicts_from_resource(resource)
    ibm_db.commit(connect)
    return rowdicts
