# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


from itertools import cycle
from datetime import datetime
import logging
import os
from time import sleep

from check_data import rzd_check_data

from multiprocessing import Pool


def init_logging(level=logging.DEBUG):
    log = logging.getLogger()
    handler = logging.StreamHandler()
    handler.level = level
    log.addHandler(handler)
    log.level = level


def check_data(args):
    i, (host, port) = args
    print(datetime.utcnow(), 'start', i, host, port)
    sleep(30)

    is_err = False
    try:
        res = rzd_check_data(verbose=False, rzd_hostname=host, rzd_port=port)
    except Exception as ex:
        print(ex)
        is_err = True
        res = repr(ex)

    return i, host, port, res, is_err


def check_parallel(n, pool_size=10):
    if n == 1:
        rzd_check_data(verbose=True)
        return

    pool = Pool(pool_size)

    hosts = cycle([
        ['10.248.3.64', 50000],
        ['127.0.0.1', 666]
    ])
    calls = [
        (i, next(hosts))
        for i in range(n)
    ]

    results = []
    for i, host, port, res, is_err in pool.imap_unordered(check_data, calls):
        dt = datetime.utcnow()
        print(dt, 'result', i, len(res), host, port)
        results.append((dt, i, host, port, res, is_err))

    for dt, i, host, port, res, is_err in results:
        print('{} {} {: <4} {: >15}:{: <6} {}'.format(dt, i, len(res), host, port, 'ERROR' if is_err else ''))


if __name__ == '__main__':
    # fix of problem:
    # Fetch Failure: [IBM][CLI Driver] CLI0113E  SQLSTATE 22007: An invalid datetime format was detected;
    # that is, an invalid string representation or value was specified. SQLSTATE=22007 SQLCODE=-99999
    os.environ['LC_ALL'] = 'C.UTF-8'

    init_logging(logging.DEBUG)
    check_parallel(40, pool_size=3)

