#include "direction_reducer.h"
using namespace NYT;

void TDirectionReducer::Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) {
    for (; input->IsValid(); input->Next()) {
        const TNode& origin = input->GetRow();
        TNode result;
        TVector<TString> fields{
            "type", "date_forward",
            "from_settlement_id", "from_station_id",
            "to_settlement_id", "to_station_id",
            "price"};
        for (const auto& field : fields) {
            result[field] = origin.At(field);
        }

        output->AddRow(result);
        return;
    }
}
