#include "helpers.h"

using namespace NYT;

TVector<TString> GetLastTables(IClientPtr client, const TString& directory, size_t top) {
    if (!client->Exists(directory)) {
        ythrow yexception();
    }

    auto childrens = client->List(directory);
    TVector<TString> tables;
    for (const auto& children : childrens) {
        tables.push_back(directory + '/' + children.AsString());
    }

    auto middleIt = tables.begin() + top;
    std::partial_sort(tables.begin(), std::min(middleIt, tables.end()), tables.end(), std::greater<TString>());
    if (tables.size() > top) {
        tables.resize(top);
    }

    return tables;
}
