#pragma once

#include <mapreduce/yt/interface/client.h>
#include <travel/hotels/lib/cpp/ordinal_date/ordinal_date.h>
#include <travel/proto/dicts/rasp/transport.pb.h>

class TRouteMapper: public NYT::IMapper<NYT::TTableReader<NYT::TNode>, NYT::TTableWriter<NYT::TNode>> {
public:
    Y_SAVELOAD_JOB(MinDate_);

    TRouteMapper() = default;
    TRouteMapper(NTravel::NOrdinalDate::TOrdinalDate minDate);
    void Do(NYT::TTableReader<NYT::TNode>* input, NYT::TTableWriter<NYT::TNode>* output) override;
private:
    void FillIds(const NYT::TNode& origin, NYT::TNode& destination, const TString& direction) const;
    NRasp::NData::TTransport_EType ParseTransportType(const TString& code) const;
private:
    NTravel::NOrdinalDate::TOrdinalDate MinDate_;
};
