#include "route_reducer.h"

using namespace NYT;

void TRouteReducer::Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) {
    TMaybe<TNode> result;

    for (; input->IsValid(); input->Next()) {
        const TNode& row = input->GetRow();
        if (row.At("skip").AsBool()) {
            continue;
        }
        result = {std::move(row)};
    }

    if (result.Defined()) {
        output->AddRow(*result);
    }
}
