# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import requests

FILES = {
    'return_policy_accident.pdf': (
        'https://www.renins.com/Media/Default/doc/im/return_policy_accident.pdf',
        '79540',
        'Thu, 10 Jan 2019 13:08:48 GMT'
    ),
    'im84.pdf': (
        'https://www.renins.com/Media/Default/doc/im/im84.pdf',
        '564186',
        'Fri, 21 Dec 2018 17:19:53 GMT'
    )
}

CUSTOM_HEADERS = {
    'user-agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/537.36 (KHTML, like Gecko) '
                  'Chrome/80.0.3987.122 YaBrowser/20.3.0.2220 Yowser/2.5 Safari/537.36',
}


class RaspFileChangedException(Exception):
    pass


def check_file(url, size, modified):
    file_size = requests.get(
        url, stream=True, verify=False, headers=CUSTOM_HEADERS,
    ).headers['Content-length']
    last_modified = requests.get(
        url, stream=True, verify=False, headers=CUSTOM_HEADERS,
    ).headers.get('Last-Modified', '')

    file_size_match = (size == str(file_size))
    last_modified_match = True
    if modified or last_modified:
        last_modified_match = (modified == last_modified)

    return not (file_size_match and last_modified_match)
