PY3_LIBRARY()

OWNER(
    g:rasp-back
)

PEERDIR(
    contrib/python/ipython
    contrib/python/requests
    contrib/python/pytz
    contrib/python/dateutil

    travel/library/python/rasp_vault
    travel/library/python/tvm_ticket_provider
)

PY_SRCS(
    smoke_tests/conftest.py
    smoke_tests/checkers.py
    smoke_tests/common_content_checkers.py
    smoke_tests/conf.py
    smoke_tests/load_tests.py
    smoke_tests/requests2curl.py
    smoke_tests/run_smoke_tests.py
    smoke_tests/settings.py
    smoke_tests/stableness.py

    smoke_tests/config/__init__.py
    smoke_tests/config/api_public/__init__.py
    smoke_tests/config/api_public/checks.py
    smoke_tests/config/api_public/content_checkers.py
    smoke_tests/config/api_public/env.py

    smoke_tests/config/blablacar/__init__.py
    smoke_tests/config/blablacar/checks.py
    smoke_tests/config/blablacar/env.py
    smoke_tests/config/blablacar/urls.py

    smoke_tests/config/export/__init__.py
    smoke_tests/config/export/checks.py
    smoke_tests/config/export/content_checkers.py
    smoke_tests/config/export/env.py

    smoke_tests/config/infocenter/__init__.py
    smoke_tests/config/infocenter/checks.py
    smoke_tests/config/infocenter/env.py
    smoke_tests/config/infocenter/urls.py

    smoke_tests/config/morda_backend/__init__.py
    smoke_tests/config/morda_backend/checks.py
    smoke_tests/config/morda_backend/content_checkers.py
    smoke_tests/config/morda_backend/env.py
    smoke_tests/config/morda_backend/threads.py

    smoke_tests/config/morda_front/__init__.py
    smoke_tests/config/morda_front/checks.py
    smoke_tests/config/morda_front/env.py
    smoke_tests/config/morda_front/urls.py
    smoke_tests/config/morda_front_newRouting/__init__.py
    smoke_tests/config/morda_front_newRouting/checks.py
    smoke_tests/config/morda_front_newRouting/env.py
    smoke_tests/config/morda_front_newRouting/urls.py

    smoke_tests/config/old_morda/__init__.py
    smoke_tests/config/old_morda/checks.py
    smoke_tests/config/old_morda/env.py

    smoke_tests/config/pathfinder_core/__init__.py
    smoke_tests/config/pathfinder_core/checks.py
    smoke_tests/config/pathfinder_core/env.py

    smoke_tests/config/suburban_selling/__init__.py
    smoke_tests/config/suburban_selling/checks.py
    smoke_tests/config/suburban_selling/env.py
    smoke_tests/config/suburban_selling/helpers.py
    smoke_tests/config/suburban_selling/suburban_order.py

    smoke_tests/config/suburban_widget/__init__.py
    smoke_tests/config/suburban_widget/checks.py
    smoke_tests/config/suburban_widget/env.py

    smoke_tests/config/suggests/__init__.py
    smoke_tests/config/suggests/checks.py
    smoke_tests/config/suggests/env.py
    smoke_tests/config/suggests/urls.py

    smoke_tests/config/touch/__init__.py
    smoke_tests/config/touch/checks.py
    smoke_tests/config/touch/env.py

    smoke_tests/config/utils.py
)

TEST_SRCS(
    smoke_tests/test_run.py
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    bin/tests
)
