# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import sys

from travel.library.python.entrypoint import *  # noqa
from travel.library.python.entrypoint import gunicorn_base, default_run
from travel.library.python.resource import extract_resources


extract_resources('travel/rasp/suburban_selling/')


def gunicorn():
    from travel.rasp.suburban_selling import wsgi
    gunicorn_base(wsgi.application)


def celery():
    from celery import maybe_patch_concurrency

    if 'multi' not in sys.argv:
        maybe_patch_concurrency()

    from celery.bin.celery import main as _main
    _main()


if __name__ == '__main__':
    default_run(globals())
