# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.server.gunicorn.default import *  # noqa
from travel.rasp.library.python.common23.server.gunicorn import default
from travel.rasp.library.python.common23.server.gunicorn import mongo_control

from travel.library.python.tracing.django import Tracing
from travel.library.python.tracing.gunicorn import build_post_fork
from travel.rasp.library.python.tracing.sampling import build_jaeger_config
from travel.rasp.suburban_selling.selling.utils import write_cert_keys


post_fork = build_post_fork(build_jaeger_config('rasp.suburban_selling'), wrapper_cls=Tracing)


def on_starting(server):
    default.on_starting(server)
    write_cert_keys()


def when_ready(server):
    default.when_ready(server)


def on_reload(server):
    default.on_reload(server)


def pre_fork(server, worker):
    default.pre_fork(server, worker)
    mongo_control.pre_fork(server, worker)
