# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.dynamic_settings.default import conf
from travel.rasp.suburban_selling.selling.aeroexpress.client import get_client
from travel.rasp.suburban_selling.selling.utils import write_cert_keys


def get_balance():
    write_cert_keys()
    client = get_client(crt_file=settings.AEROEX_CRT, key_file=settings.AEROEX_KEY)
    response = client.get_agent_balance()
    return response['status'], response['balance']


def check():
    status, balance = get_balance()

    if status == 'OK' and balance > conf.AEROEX_BALANCE_LIMIT:
        message = 'status: {}. balance: {}.'.format(status, balance)
        print(message)
        return message
    else:
        message = 'aeroex check_balance fail. status: {}. balance: {}.'.format(status, balance)
        print(message)
        raise Exception(message)


if __name__ == '__main__':
    check()
