# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from mongoengine import Document, EmbeddedDocument, DynamicEmbeddedDocument


class AbstractDocument(Document):
    meta = {
        'abstract': True,
        'strict': False,
        'db_alias': 'suburban_selling',
        'index_background': True
    }


class AbstractEmbeddedDocument(EmbeddedDocument):
    meta = {
        'abstract': True,
        'strict': False
    }


class AbstractDynamicEmbeddedDocument(DynamicEmbeddedDocument):
    meta = {
        'abstract': True,
        'strict': False
    }
