# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import datetime, timedelta
from decimal import Decimal

import factory
from bson.decimal128 import Decimal128
from factory.mongoengine import MongoEngineFactory

from common.models.schedule import Company
from travel.rasp.library.python.common23.date.environment import now
from travel.rasp.suburban_selling.selling.aeroexpress.models import (
    AeroexMenu, SuburbanTariff as AeroexTariff, TariffKey, TariffData, ClientContract, ClientContracts, AeroBilling
)


class AeroexMenuFactory(MongoEngineFactory):
    class Meta:
        model = AeroexMenu

    menu_id = 1
    name = 'Стандарт'
    last_id = True
    price = 420
    label = 'Тариф'
    order_type = 25
    max_tickets = 10
    max_days = 90
    description = ('1 поездка в вагоне стандартного класса.'
                   ' Билет действителен на всех трех направлениях от/до московских аэропортов, '
                   'на дату, указанную в проездном документе.')


class TariffKeyFactory(MongoEngineFactory):
    class Meta:
        model = TariffKey

    station_from = 501
    station_to = 502
    express_type = 'aeroexpress'
    company = Company.AEROEXPRESS_ID


class TariffDataFactory(MongoEngineFactory):
    class Meta:
        model = TariffData

    menu_id = 1,
    name = 'стандарт',
    price = Decimal128('420'),
    order_type = 25,
    description = 'на стандарте',
    max_days = 90
    begin_dt = factory.Sequence(lambda n: datetime.now())
    end_dt = factory.Sequence(lambda n: datetime.now() + timedelta(days=90))


class AeroexTariffFactory(MongoEngineFactory):
    class Meta:
        model = AeroexTariff

    key = factory.SubFactory(TariffKey)
    data = factory.SubFactory(TariffData)


class ClientContractFactory(MongoEngineFactory):
    class Meta:
        model = ClientContract

    services = [35, AeroBilling.contract_service_id]
    start_dt = datetime(2017, 11, 10)
    finish_dt = None
    is_active = True
    is_cancelled = False
    is_suspended = False
    partner_commission_sum = Decimal('40.0')


class ClientContractsFactory(MongoEngineFactory):
    class Meta:
        model = ClientContracts

    updated_at = factory.LazyFunction(now)
    partner_id = AeroBilling.partner_id
    contracts = [ClientContractFactory()]
