# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from typing import Dict
from dateutil import parser

from common.dynamic_settings.default import conf
from travel.rasp.library.python.api_clients.travel_api.providers.aeroexpress import AeroexpressServiceBookData

from travel.rasp.suburban_selling.selling.order.helpers import ForbiddenOrderError, SuburbanServiceFactory


class AeroexpressServiceFactory(SuburbanServiceFactory):
    def raise_if_order_forbidden(self):
        # type: () -> ()
        if not conf.SUBURBAN_SELLING__AEROEX_ORDER_ENABLED:
            raise ForbiddenOrderError(
                'Aeroexpress order is forbidden by the setting SUBURBAN_SELLING__AEROEX_ORDER_ENABLED'
            )
        if not conf.SUBURBAN_SELLING_ENABLED:
            raise ForbiddenOrderError(
                'Aeroexpress order is forbidden by the setting SUBURBAN_SELLING_ENABLED'
            )

    def make_book_data(self, order_data):
        # type: (Dict) -> AeroexpressServiceBookData

        book_data = order_data['book_data']

        return AeroexpressServiceBookData(
            int(book_data['menu_id']),
            int(book_data['order_type']),
            parser.parse(order_data['departure_date']).date().isoformat()
        )
