# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from bson.decimal128 import Decimal128
from datetime import timedelta

from django.conf import settings

from travel.rasp.suburban_selling.selling.aeroexpress.client import get_client
from travel.rasp.suburban_selling.selling.aeroexpress.models import AeroexMenu, SuburbanTariff, TariffData, TariffKey

from common.models.schedule import Company
from common.models_abstract.schedule import ExpressType
from travel.rasp.library.python.common23.date.environment import now_aware


log = logging.getLogger(__name__)


PAVELETSKAYA_ID = 2000005
VERHNIE_KOTLY_ID = 9868808
DME_ID = 9600216

BELORUSSKAYA_ID = 2000006
SAVELOVSKAYA_ID = 2000009
OKRUZHNAYA_ID = 9601830
SVO_SOUTH_ID = 9881841
SVO_NORTH_ID = 9881704

KIEVSKAYA_ID = 2000007
VKO_ID = 9600215


STATION_PAIRS = [
    # На Домодедово
    {
        'from': DME_ID,
        'to': PAVELETSKAYA_ID,
    },
    {
        'from': DME_ID,
        'to': VERHNIE_KOTLY_ID,
    },
    {
        'from': PAVELETSKAYA_ID,
        'to': DME_ID,
    },
    {
        'from': VERHNIE_KOTLY_ID,
        'to': DME_ID,
    },
    {
        'from': VERHNIE_KOTLY_ID,
        'to': PAVELETSKAYA_ID,
    },
    {
        'from': PAVELETSKAYA_ID,
        'to': VERHNIE_KOTLY_ID,
    },

    # На Внуково
    {
        'from': VKO_ID,
        'to': KIEVSKAYA_ID,
    },
    {
        'from': KIEVSKAYA_ID,
        'to': VKO_ID,
    },

    # На Шереметьево
    {
        'from': SVO_SOUTH_ID,
        'to': BELORUSSKAYA_ID,
    },
    {
        'from': SVO_NORTH_ID,
        'to': BELORUSSKAYA_ID,
    },
    {
        'from': SVO_SOUTH_ID,
        'to': SAVELOVSKAYA_ID,
    },
    {
        'from': SVO_NORTH_ID,
        'to': SAVELOVSKAYA_ID,
    },
    {
        'from': SVO_SOUTH_ID,
        'to': OKRUZHNAYA_ID,
    },
    {
        'from': SVO_NORTH_ID,
        'to': OKRUZHNAYA_ID,
    },

    {
        'from': BELORUSSKAYA_ID,
        'to': SVO_SOUTH_ID,
    },
    {
        'from': BELORUSSKAYA_ID,
        'to': SVO_NORTH_ID,
    },
    {
        'from': SAVELOVSKAYA_ID,
        'to': SVO_SOUTH_ID,
    },
    {
        'from': SAVELOVSKAYA_ID,
        'to': SVO_NORTH_ID,
    },
    {
        'from': OKRUZHNAYA_ID,
        'to': SVO_SOUTH_ID,
    },
    {
        'from': OKRUZHNAYA_ID,
        'to': SVO_NORTH_ID,
    },
    {
        'from': BELORUSSKAYA_ID,
        'to': OKRUZHNAYA_ID,
    },
    {
        'from': OKRUZHNAYA_ID,
        'to': BELORUSSKAYA_ID,
    },
    {
        'from': SAVELOVSKAYA_ID,
        'to': OKRUZHNAYA_ID,
    },
    {
        'from': OKRUZHNAYA_ID,
        'to': SAVELOVSKAYA_ID,
    },
]


def save_menu(menu):
    tariffs = []
    menu_list = []
    for item in menu:
        if item['id'] not in settings.TARIFFS_ADDITIONS.keys():
            continue

        aeroex_menu = AeroexMenu(
            menu_id=item['id'],
            name=item['name'],
            last_id=item['lastId'],
            price=item['price'],
            label=item['label'],
            order_type=item['orderType'],
            max_tickets=item['maxTickets'],
            max_days=item['maxDays'],
            description=item['description']
        )
        menu_list.append(aeroex_menu)

    AeroexMenu.objects().delete()
    AeroexMenu.objects.insert(menu_list)

    for aeroex_menu in AeroexMenu.objects.all():
        days_from, days_to = 0, aeroex_menu.max_days
        now_dt = now_aware().replace(hour=0, minute=0, second=0, microsecond=0)

        for station_pair in STATION_PAIRS:
            tariff = SuburbanTariff(
                key=TariffKey(
                    station_from=station_pair['from'],
                    station_to=station_pair['to'],
                    express_type=ExpressType.AEROEXPRESS,
                    company=Company.AEROEXPRESS_ID,
                ),
                data=TariffData(
                    menu_id=aeroex_menu.menu_id,
                    name=aeroex_menu.name,
                    price=Decimal128(aeroex_menu.price),
                    order_type=aeroex_menu.order_type,
                    description=aeroex_menu.get_description(),
                    max_days=aeroex_menu.max_days,
                    begin_dt=(now_dt + timedelta(days=days_from)),
                    end_dt=(now_dt + timedelta(days=days_to))
                )
            )

            tariffs.append(tariff)

    SuburbanTariff.objects(key__company=Company.AEROEXPRESS_ID, key__express_type=ExpressType.AEROEXPRESS).delete()
    SuburbanTariff.objects.insert(tariffs)


def update_menu(crt_file, key_file, url=None):
    client = get_client(crt_file=crt_file, key_file=key_file, url=url)
    menu = client.get_menu()
    save_menu(menu)
