# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.apps import AppConfig
from django.conf import settings

from travel.rasp.library.python.common23.date.environment import is_migration_allowed
from travel.rasp.library.python.common23.logging.mongo.mongo_handler import MongoHandler


class SuburbanSellingAppConfig(AppConfig):
    name = 'travel.rasp.suburban_selling.selling'
    label = 'suburban_selling'

    def ready(self):
        from travel.rasp.suburban_selling.selling.celery import app  # noqa

        if is_migration_allowed():
            MongoHandler.ensure_indexes_from_config(settings.LOGGING)
