# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

"""
Минимально необходимые настройки Celery - как для воркеров, так и для кода, отправляющего таски.
"""
import os

from celery import Celery

from common.celery.worker import PatchedConsumer


app = Celery('suburban_selling')
app.conf.update({
    'worker_consumer': PatchedConsumer,
    'worker_concurrency': os.getenv('CELERY_CONCURRENCY', 50),
    'worker_pool': os.getenv('CELERY_POOL', 'gevent'),
    'worker_max_tasks_per_child': os.getenv('CELERY_MAX_TASKS_PER_CHILD', 1000)
})
app.config_from_object('django.conf:settings', namespace='CELERY')
