# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'local_settings')

import django
django.setup()  # noqa: E402

from celery.signals import task_prerun, worker_init, celeryd_init
from celery.schedules import crontab

from common.db.mongo import ConnectionProxy
from common.db.switcher import switcher

from travel.rasp.suburban_selling.selling.tasks import *  # noqa

from travel.rasp.suburban_selling.selling.celery.app import app  # noqa: F401
from travel.rasp.suburban_selling.selling.utils import write_cert_keys


@task_prerun.connect
def sync_db(**kwargs):
    print('sync_db', '=' * 100)
    switcher.sync_with_lazy_reconnect()


@celeryd_init.connect
def configure_workers(**kwargs):
    write_cert_keys()


@worker_init.connect
def close_mongo_connections(**kwargs):
    ConnectionProxy.close_connections()


app.conf.beat_scheduler = 'common.celery.beat:FixedPersistentScheduler'
app.conf.beat_schedule = {
    'update_menu': {
        'task': 'travel.rasp.suburban_selling.selling.tasks.update_menu.update',
        'schedule': crontab(hour='*', minute='5'),
    },
    'prepare_aeroexpress_orders': {
        'task': 'travel.rasp.suburban_selling.selling.tasks.prepare_aeroexpress_orders.send_aeroex_order_email',
        'schedule': crontab(day_of_month='1,11,21', hour='3', minute='0'),
    },
    'update_client_contracts': {
        'task': 'travel.rasp.suburban_selling.selling.tasks.client_contracts.update',
        'schedule': crontab(hour='*/6', minute='0'),
    },
    'delete_old_tariffs':
    {
        'task': 'travel.rasp.suburban_selling.selling.tasks.delete_old_tariffs.delete_old_tariffs',
        'schedule': crontab(hour='3', minute='25'),
    },
    'movista_load_stops_data':
    {
        'task': 'travel.rasp.suburban_selling.selling.tasks.movista_stops.load_stops_data',
        'schedule': crontab(hour='*/2', minute='10'),
    }
}
