# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import datetime, date

import factory
from bson.decimal128 import Decimal128
from factory.mongoengine import MongoEngineFactory

from travel.rasp.suburban_selling.selling.im.models import ImTariffs, BookData, ImTrain, IM_TRAIN_IS_AVAILABLE


class BookDataFactory(MongoEngineFactory):
    class Meta:
        model = BookData

    date = '2020-10-24'
    station_from_express_id = '4242'
    station_to_express_id = '4343'


class ImTrainFactory(MongoEngineFactory):
    class Meta:
        model = ImTrain

    carrier_im_code = 'СЗППК'
    train_number = '6666'
    departure_dt = datetime(2020, 10, 24, 12)
    price = Decimal128('420.01')
    im_provider = 'P6'
    is_sale_forbidden = False
    availability_indication = IM_TRAIN_IS_AVAILABLE


class ImTariffsFactory(MongoEngineFactory):
    class Meta:
        model = ImTariffs

    date = date(2020, 10, 24)
    station_from = 42
    station_to = 43
    updated = factory.Sequence(lambda n: datetime.utcnow())
    update_started = factory.Sequence(lambda n: datetime.utcnow())
    book_data = factory.SubFactory(BookDataFactory)
    im_trains = []
