# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import six
from mongoengine.fields import (
    IntField, StringField, DecimalField, DateField, DateTimeField, BooleanField,
    EmbeddedDocumentListField, EmbeddedDocumentField
)

from travel.rasp.suburban_selling.selling.abstract_models import AbstractDocument, AbstractEmbeddedDocument


IM_TRAIN_IS_AVAILABLE = 'Available'


class BookData(AbstractEmbeddedDocument):
    date = StringField(required=True)
    station_from_express_id = StringField(required=True)
    station_to_express_id = StringField(required=True)


class ImTrain(AbstractEmbeddedDocument):
    carrier_im_code = StringField(required=True)
    train_number = StringField(required=True)
    departure_dt = StringField(required=True)
    price = DecimalField(precision=2, min_value=0.01, required=True)
    im_provider = StringField(required=True)
    is_sale_forbidden = BooleanField(default=False)
    availability_indication = StringField(default=IM_TRAIN_IS_AVAILABLE)


@six.python_2_unicode_compatible
class ImTariffs(AbstractDocument):
    date = DateField(required=True)
    station_from = IntField(required=True)
    station_to = IntField(required=True)

    book_data = EmbeddedDocumentField(BookData, required=True)

    updated = DateTimeField()
    update_started = DateTimeField()

    im_trains = EmbeddedDocumentListField(ImTrain)

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return 'Tariffs on {} from {} to {}'.format(self.date, self.station_from, self.station_to)

    def __hash__(self):
        return hash((self.date, self.station_from, self.station_to))

    meta = {
        'indexes': [
            {
                'fields': ['station_from', 'station_to', 'date'],
                'name': 'key_index',
                'unique': True,
            }
        ],
        'index_background': True
    }
