# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import datetime

import factory
from bson.decimal128 import Decimal128
from factory.mongoengine import MongoEngineFactory

from common.models.tariffs import TariffTypeCode
from travel.rasp.suburban_selling.selling.movista.models import MovistaTariffs, Tariff, BookData, MovistaStations


class BookDataFactory(MongoEngineFactory):
    class Meta:
        model = BookData

    date = '2020-10-24'
    station_from_express_id = '4242'
    station_to_express_id = '4343'


class TariffFactory(MongoEngineFactory):
    class Meta:
        model = Tariff

    type = TariffTypeCode.USUAL
    price = Decimal128('420.01')
    fare_id = 123456


class MovistaTariffsFactory(MongoEngineFactory):
    class Meta:
        model = MovistaTariffs

    date = datetime(2020, 10, 24)
    station_from = 42
    station_to = 43
    can_sell = True
    updated = factory.Sequence(lambda n: datetime.utcnow())

    book_data = factory.SubFactory(BookDataFactory)
    tariffs = []


class MovistaStationsFactory(MongoEngineFactory):
    class Meta:
        model = MovistaStations

    station_id = 111
    has_wicket = True
    wicket_type = 'MID2Tutorial'
