# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from datetime import datetime, timedelta

from common.celery.task import single_launch_task
from common.utils.metrics import report_progress

from travel.rasp.suburban_selling.selling.im.models import ImTariffs
from travel.rasp.suburban_selling.selling.movista.models import MovistaTariffs


log = logging.getLogger(__name__)


DAYS_TO_KEEP_OLD_MOVISTA_TARIFFS = 4
DAYS_TO_KEEP_OLD_IM_TARIFFS = 4


@report_progress('delete_old_movista_tariffs')
def delete_old_movista_tariffs():
    valid_updated = datetime.utcnow() - timedelta(days=DAYS_TO_KEEP_OLD_MOVISTA_TARIFFS)
    MovistaTariffs.objects(updated__lt=valid_updated).delete()


@report_progress('delete_old_im_tariffs')
def delete_old_im_tariffs():
    valid_updated = datetime.utcnow() - timedelta(days=DAYS_TO_KEEP_OLD_IM_TARIFFS)
    ImTariffs.objects(updated__lt=valid_updated).delete()


@single_launch_task()
def delete_old_tariffs():
    delete_old_im_tariffs()
    delete_old_movista_tariffs()
