# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
from django.conf import settings

from django.conf.urls import url

from common.settings.configuration import Configuration
from common.settings.utils import bool_converter

from travel.rasp.suburban_selling.selling.order.user_action_event import user_action_event
from travel.rasp.suburban_selling.selling.order.create_order import create_order
from travel.rasp.suburban_selling.selling.order.order_info import order_info
from travel.rasp.suburban_selling.selling.order.orders_list_info import orders_list_info
from travel.rasp.suburban_selling.selling.views.gdpr import gdpr_takeout
from travel.rasp.suburban_selling.selling.tariffs.tariffs_views import get_tariffs_view
from travel.rasp.suburban_selling.selling.views.user_data import get_user_data
from travel.rasp.suburban_selling.selling.views.views import ping


urlpatterns = [
    url(r'^ping/?', ping),

    url(r'^get_tariffs/?$', get_tariffs_view),

    url(r'^get_user_data/?$', get_user_data),

    url(r'^create_order/?$', create_order),
    url(r'^order_info/?$', order_info),
    url(r'^orders_list_info/?$', orders_list_info),
    url(r'^user_action_event/?$', user_action_event),
]

# Сделано в рамках https://st.yandex-team.ru/RASPFRONT-6578
# Для https://st.yandex-team.ru/SECAUDIT-2826#5c751ddbe35a91001fc8ba9a
# Доступ к выгрузке для takeout не доступен из окружения production, но доступен из production-internal
# Окружения production и production-internal отличаются значением переменной ENABLE_TAKEOUT_URL
if (settings.YANDEX_ENVIRONMENT_TYPE != Configuration.PRODUCTION
        or bool_converter(os.getenv('ENABLE_TAKEOUT_URL', 'false'))):
    urlpatterns.append(url(r'^gdpr_takeout/?$', gdpr_takeout))
