# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from rasp_vault.api import get_secret


def write_cert_keys():
    """
    Берет из секретницы ключи для доступа к аэроэкспрессу и записывает их в файлы crt и key
    Впоследствии zeep берет их из этих файлов
    """
    with open(settings.AEROEX_CRT, 'w') as file_crt:
        crt = get_secret(settings.AEROEX_CRT_SECRET)
        file_crt.write(crt)
    with open(settings.AEROEX_KEY, 'w') as file_key:
        key = get_secret(settings.AEROEX_KEY_SECRET)
        file_key.write(key)
