# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from functools import partial
from typing import Any, Optional, AnyStr

from dateutil import parser
from django.contrib.auth.decorators import login_required
from marshmallow import fields

from common.utils.blackbox_wrapper import get_blackbox_oauth_args, get_blackbox_oauth_info


log = logging.getLogger(__name__)

staff_login_required = partial(login_required, redirect_field_name=None, login_url='/')


class DateField(fields.String):
    def _deserialize(self, value, attr, data):
        date = super(DateField, self)._deserialize(value, attr, data)
        try:
            date = date.replace(' ', '+')
            return parser.parse(date)
        except Exception:
            return None


def get_blackbox_info(request, **extra_bb_args):
    bb_args = {'get_user_ticket': 'yes'}
    bb_args.update(get_blackbox_oauth_args(request))
    bb_args.update(extra_bb_args)

    return get_blackbox_oauth_info(**bb_args)


def get_user_from_blackbox(request):
    # type: (Any) -> (Optional[int], Optional[AnyStr])

    if not request.META.get('HTTP_AUTHORIZATION'):
        return None, None

    try:
        blackbox_info = get_blackbox_info(request)
        return blackbox_info.uid, blackbox_info.user_ticket

    except Exception:
        log.exception('Не смогли получить uid пользователя')
        raise
