PY2_LIBRARY()

OWNER(
    g:rasp-back
)

PEERDIR(
    yql/library/python

    contrib/python/ipython
    contrib/python/zeep
    contrib/python/regex
    contrib/python/openpyxl

    travel/library/python/resource
    travel/library/python/tracing/django
    travel/library/python/tracing/gunicorn
    travel/library/python/tracing/instrumentation
    travel/library/python/entrypoint

    travel/proto/suburban

    travel/rasp/library/python/api_clients/im
    travel/rasp/library/python/api_clients/movista
    travel/rasp/library/python/api_clients/travel_api
    travel/rasp/library/python/common
    travel/rasp/library/python/tracing
)


PY_SRCS(
    TOP_LEVEL
    settings.py
    tests_settings.py
)


PY_SRCS(
    app.py
    docker/local_settings.py
    gunicorn_conf.py
    wsgi.py

    manual_scripts/check_balance.py

    selling/__init__.py
    selling/abstract_models.py

    selling/aeroexpress/client.py
    selling/aeroexpress/factories.py
    selling/aeroexpress/models.py
    selling/aeroexpress/order.py
    selling/aeroexpress/tariffs.py
    selling/aeroexpress/update_menu.py

    selling/app.py

    selling/celery/app.py
    selling/celery/worker.py

    selling/im/factories.py
    selling/im/get_from_im.py
    selling/im/models.py
    selling/im/order.py
    selling/im/tariffs.py

    selling/models.py

    selling/movista/factories.py
    selling/movista/models.py
    selling/movista/order.py
    selling/movista/tariffs.py

    selling/order/cpa.py
    selling/order/create_order.py
    selling/order/helpers.py
    selling/order/order_info.py
    selling/order/orders_list_info.py
    selling/order/request_serialization.py
    selling/order/user_action_event.py

    selling/tariffs/api.py
    selling/tariffs/from_to_key_cache_provider.py
    selling/tariffs/interfaces.py
    selling/tariffs/selling_companies.py
    selling/tariffs/tariffs_configuration.py
    selling/tariffs/tariffs_getter.py
    selling/tariffs/tariffs_views.py

    selling/tasks/__init__.py
    selling/tasks/client_contracts.py
    selling/tasks/delete_old_tariffs.py
    selling/tasks/movista_stops.py
    selling/tasks/prepare_aeroexpress_orders.py
    selling/tasks/update_menu.py

    selling/urls.py

    selling/utils.py

    selling/views/gdpr.py
    selling/views/user_data.py
    selling/views/utils.py
    selling/views/views.py
)

RESOURCE_FILES( PREFIX travel/rasp/suburban_selling/
    selling/templates/excel_order.xlsx
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)
