# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os

from travel.library.python.entrypoint import *  # noqa
from travel.library.python.entrypoint import default_run, scheduler_base, launch_base, gunicorn_base


def _load_project():
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "local_settings")

    import django
    django.setup()

    from common.db.switcher import switcher
    switcher.sync_db()

def launch():
    _load_project()

    from travel.rasp.suburban_tasks.job_config import job_config
    launch_base(job_config)


def scheduler():
    _load_project()

    from travel.rasp.suburban_tasks.job_config import job_config
    scheduler_base(job_config, 'travel.rasp.suburban_tasks.app:launch')


def rzd_check_connect():
    """
    Ручная проверка коннекта до ржд-проксей.
    """
    _load_project()

    from django.conf import settings
    from travel.rasp.suburban_tasks.suburban_tasks.rzd_hosts import get_rzd_hosts_and_ports
    from travel.rasp.suburban_tasks.suburban_tasks.rzd_utils import get_raw_connection

    msgs = []
    for host, port in get_rzd_hosts_and_ports():
        try:
            get_raw_connection(host=host, port=port, db_name=settings.RZD_SUBURBAN_EVENTS_DB)
        except Exception as ex:
            msg = repr(ex)
        else:
            msg = 'connection to {} is successfull'.format(host)
        msgs.append(msg)
        print(msg)

    print('============== check results:')
    for msg in msgs:
        print(msg)


def rzd_check_data():
    """
    Ручная проверка, что данные от РЖД получить можем.
    """
    _load_project()

    from datetime import datetime, timedelta
    dt_to = datetime.now() - timedelta(minutes=10)
    dt_from = dt_to - timedelta(minutes=5)

    from travel.rasp.suburban_tasks.suburban_tasks.scripts.update_suburban_events import fetch_data
    print('rzd_check_data from {} to {}'.format(dt_from, dt_to))
    res, tries = fetch_data(dt_from, dt_to)
    print("Rows examples:")
    for row in res[:3]:
        print(row)
    print("rows", len(res))


if __name__ == '__main__':
    default_run(globals())
